package gov.va.genisis2Test.exceptions;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.exceptions.ErrorResponse;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;

/**
 * 
 * @author1 Janet Lopez
 * 
 * The Class ErrorResponseTest.
 * 
 * Description: In this ErrorResponseTest Class which extends the abstract
 * class, AbstractMockMvcTests, junit tests are defined.
 * 
 */
public class ErrorResponseTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(ErrorResponseTest.class);

	/**
	 * Test error response.
	 */
	@Test
	public void TestErrorResponse() {

		logger.info("**********Junit Test Error Response**********");

		ErrorResponse errorResponse = new ErrorResponse();
		Assert.assertEquals(0, errorResponse.getErrorCode());
		Assert.assertNull(errorResponse.getMessage());

		errorResponse.setErrorCode(1);
		errorResponse.setMessage("messageTestOne");

		Assert.assertEquals(1, errorResponse.getErrorCode());
		Assert.assertEquals("messageTestOne", errorResponse.getMessage());

		logger.info("**********Junit Test Error Response**********");
	}

}
